package model;

/**
 * A generic and abstract {@link Board} builder
 * 
 * @author simone
 *
 */
public interface IGenerator {

	/**
	 * Create a new istance of {@link Board} by returning a matrix of {@link Box} istances
	 * 
	 * @return: matrix of {@link Box} istances that can be used to create a new {@link Board}
	 */
	public Box[][] generate();

	public abstract int getBoardWidth();

	public abstract int getBoardHeight();

}